<?php
/**
 * Uninstall script for ContentBeast Auto Publisher
 * 
 * This file is called when the plugin is deleted from WordPress.
 * It removes all plugin data from the database.
 */

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete plugin options
delete_option('contentbeast_auto_pub_opts');

// Remove all post meta added by this plugin
global $wpdb;
$wpdb->query("DELETE FROM {$wpdb->postmeta} WHERE meta_key = '_contentbeast_canonical_url'");

// Clear scheduled cron events
$timestamp = wp_next_scheduled('contentbeast_daily_publish_cron');
if ($timestamp) {
    wp_unschedule_event($timestamp, 'contentbeast_daily_publish_cron');
}

// Note: We don't delete SEO plugin meta fields (_yoast_wpseo_metadesc, etc.) 
// because those may be useful even after plugin removal
